import 'package:photogram_admin_cp/import/core.dart';
import 'package:photogram_admin_cp/import/data.dart';

class AdminModel extends AbstractModel {
  @override
  int get intId => _intId;
  String get id => _stringId;

  // primary key

  late final int _intId;
  late final String _stringId;

  // creds

  late String _username;

  // meta

  late String _metaAccess;
  late String _metaLastActive;

  // stamp

  late String _stampRegistration;

  /*
  |--------------------------------------------------------------------------
  | getters:
  |--------------------------------------------------------------------------
  */

  String get username => _username;

  // meta

  String get metaAccess => _metaAccess;
  String get metaLastActive => _metaLastActive;

  // stamp

  String get stampRegistration => _stampRegistration;

  // helper getters

  bool get isLoggedIn => _metaAccess.isNotEmpty;

  /*
  |--------------------------------------------------------------------------
  | factory:
  |--------------------------------------------------------------------------
  */

  AdminModel();

  factory AdminModel.none() => AdminModel();

  /*
  |--------------------------------------------------------------------------
  | from json:
  |--------------------------------------------------------------------------
  */

  AdminModel.fromJson(Map<String, dynamic> jsonMap) {
    /*
    |--------------------------------------------------------------------------
    | try setting all fields:
    |--------------------------------------------------------------------------
    */
    try {
      // primary key

      _intId = AppUtils.intVal(jsonMap[UserTable.id]);

      _stringId = jsonMap[UserTable.id];

      // creds

      _username = jsonMap[UserTable.username];

      // meta

      _metaAccess = jsonMap[UserTable.metaAccess] ?? ''; // private
      _metaLastActive = jsonMap[UserTable.metaLastActive];

      // stamps

      _stampRegistration = jsonMap[UserTable.stampRegistration] ?? ''; // private

      isModel = true;

      /*
      |--------------------------------------------------------------------------
      | failed
      |--------------------------------------------------------------------------
      */
    } catch (e) {
      AppLogger.info(e, logType: AppLogType.parser);
    }
  }

  Map<String, dynamic> toJson() => <String, dynamic>{
        UserTable.id: id,

        // creds

        UserTable.username: username,

        // meta

        UserTable.metaAccess: metaAccess,
        UserTable.metaLastActive: metaLastActive,

        // stamp

        UserTable.stampRegistration: stampRegistration,
      };

  @override
  void mergeChanges(dynamic receivedModel) {
    receivedModel as AdminModel;

    // creds

    _username = receivedModel.username;

    // meta

    _metaAccess = receivedModel.metaAccess;
    _metaLastActive = receivedModel.metaLastActive;

    // stamps

    _stampRegistration = receivedModel.stampRegistration;
  }
}
